'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Anrede_LostFocus()
    Me.Anrede.Value = Trim(Me.Anrede.Value)
End Sub

Private Sub Betreff_LostFocus()
    Me.Betreff.Value = Trim(Me.Betreff.Value)
End Sub

Private Sub Bezeichnung_Exit(Cancel As Integer)
    Me.Bezeichnung.Value = Trim(Me.Bezeichnung.Value)
End Sub

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click

    'Pflichteingaben prfen
    If (IsNull(Me.Bezeichnung.Value)) Or (Len(Me.Bezeichnung.Value) < 1) Then
        MsgBox "Bitte geben Sie eine Bezeichnung fr die Briefvorlage ein.", vbOKOnly + vbInformation, "Hinweis"
        Me.Bezeichnung.SetFocus
        Exit Sub
    End If
    
    'bei Neuanlage: Aufrufendes Formular zwecks Aktualisierung schlieen und wieder ffnen
 '   If AenderungsArt = "Neu" Then
 '       DoCmd.Close acForm, "Serienbriefe", acSaveYes
 '       DoCmd.OpenForm "Serienbriefe"
 '   End If
    
    'Liste im aufrufenden Formular aktualisieren
    Forms![Serienbriefe].[Serienbriefe_Liste].Form.Requery

    'sich selbst schlieen
    DoCmd.Close acForm, "Briefvorlage"

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)

    'bergebene laufende Nr. der Briefvorlage auswerten und anzeigen
    Dim strBriefvorlage As Variant
    
    strBriefvorlage = Me.OpenArgs
    
    If Len(strBriefvorlage) > 0 Then
        Me.lfd_Nr.Visible = True
        DoCmd.GoToControl "lfd_Nr"
        DoCmd.FindRecord strBriefvorlage, , True, , True, , True
        Me.Bezeichnung.SetFocus
        Me.lfd_Nr.Visible = False
    End If

End Sub
